-- Hedgewars Shotgun Training
-- Scripting Example

-- Lines such as this one are comments - they are ignored
-- by the game, no matter what kind of text is in there.
-- It's also possible to place a comment after some real
-- instruction as you see below. In short, everything
-- following "--" is ignored.

---------------------------------------------------------------
-- At first we put all text we'd like to use in some arrays.
-- This way we're able to localize the text to be shown without
-- modifying other files.
-- The language to be used is stored in the global variable
-- 'L' that is set by the game (string).
-- Text may then be accessed using "arrayname[L]".

local caption = {
	["en"] = "Mission #3: Ice"
	-- To add other languages, just add lines similar to the
	-- existing ones - don't forget the trailing ","!
	}

local subcaption = {
	["en"] = "Hello"
	}

local goal = {
	["en"] = "This next test is impossible"
	}

local timeout = {
	["en"] = "Oh no! Just try again."
	}

local success = {
	["en"] = "Congratulations!"
	}

local teamname = {
	["en"] = "Bloody Rookies"
	}

local hogname = {
	["en"] = "Hunter"
	}

-- To handle missing texts we define a small wrapper function that
-- we'll use to retrieve text.
local function loc(text)
	if text == nil then return "**missing**"
	elseif text[L] == nil then return text["en"]
	else return text[L]
	end
end

---------------------------------------------------------------



-- This variable controls how many milliseconds/ticks we'd
-- like to wait before we end the round once all targets
-- have been destroyed.
local player = nil -- This variable will point to the hog's gear
local instructor = nil
--local enemy1 = nil

local ehhs = {}

local GameOver = false

local cBlowTorch1
local cJetpack1
local cJetpack2
local cGirder1
local cPortalGun2
local cBaseball
local cFirePunch1
local cFirePunch2
local cGirder2

testChamberStarted = false
-- zone variables
local testChamber
local zXMin = {}
local zWidth = {}
local zYMin = {}
local zHeight = {}
local zOccupied = {}
local zCount = 0

function CreateZone(xMin, yMin, width, height)

	zXMin[zCount] = xMin
	zYMin[zCount] = yMin
	zWidth[zCount] = width
	zHeight[zCount] = height
	zOccupied[zCount] = false
	zCount = zCount + 1

	return (zCount-1)

end

function GearIsInZone(gear, zI)

	if (GetX(gear) > zXMin[zI]) and (GetX(gear) < (zXMin[zI]+zWidth[zI])) and (GetY(gear) > zYMin[zI]) and (GetY(gear) < (zYMin[zI]+zHeight[zI])) then
		zOccupied[zI] = true
	else
		zOccupied[zI] = false
	end

	return zOccupied[zI]

end

function onGameInit()

	-- Things we don't modify here will use their default values.

	Seed = 0 -- The base number for the random number generator
	GameFlags = gfInfAttack + gfDisableWind-- Game settings and rules
			--10000 seems too short, but otherwise the drill wins could add EVEN MORE MINES???
	TurnTime = 10000 -- The time the player has to move each round (in ms)
	CaseFreq = 0 -- The frequency of crate drops
	MinesNum = 0 -- The number of mines being placed
	MinesTime  = 1000
	Explosives = 0 -- The number of explosives being placed
	Delay = 2 -- The delay between each round
	Map = "IceChallenge" -- The map to be played
	Theme = "Snow" -- The theme to be used


	AddTeam(loc(teamname), 14483456, "Simple", "Island", "Default")
	player = AddHog(loc(hogname), 0, 1, "NoHat")

			--852718
	AddTeam("Toxic Team", 	1175851, "Simple", "Island", "Default")
	ehhs[0] = AddHog("Poison #0", 1, 40, "Skull")
	ehhs[1] = AddHog("Poison #1", 1, 100, "Skull")
	ehhs[2] = AddHog("Poison #2", 1, 100, "Skull")
	ehhs[3] = AddHog("Poison #3", 1, 50, "Skull")
	ehhs[4] = AddHog("Poison #4", 1, 50, "Skull")
	ehhs[5] = AddHog("Poison #5", 1, 50, "Skull")

	ehhs[6] = AddHog("Poison #6", 1, 10, "Skull")
	--ehhs[7] = AddHog("Poison #5", 1, 100, "Skull")

	AddTeam("Bad Dudes", 	1175851, "Simple", "Island", "Default")
	ehhs[7] = AddHog("Poison #7", 1, 50, "Skull")
	ehhs[8] = AddHog("Poison #8", 1, 50, "Skull")


	SetGearPosition(player, 118, 1357)
	--SetGearPosition(player, 2405, 435)
	SetGearPosition(ehhs[0], 1414, 1914)
	SetGearPosition(ehhs[1], 2252, 1800)
	SetGearPosition(ehhs[2], 2708, 1782)

	SetGearPosition(ehhs[3], 3288, 1638)
	SetGearPosition(ehhs[4], 3620, 1638)
	SetGearPosition(ehhs[5], 3453, 1773)

	--SetGearPosition(ehhs[6], 3134, 363)
	SetGearPosition(ehhs[6], 3240, 80)
	--AddGear(3190, 100, gtGrenade, 0, 0, 0, 2000)


	SetGearPosition(ehhs[7], 289, 96)
	SetGearPosition(ehhs[8], 208, 44)

	testChamber = CreateZone(3010,468,222,124)

	--SetWind(0)



end


function onGameStart()


	cBlowTorch1 = SpawnAmmoCrate(726,1879,amBlowTorch)	--the first blowtorch
	cJetpack1 = SpawnAmmoCrate(973,1760,amJetpack)	-- (probably) first jetpack)

	SpawnAmmoCrate(1763,1841,amBazooka)	-- beginning
	SpawnAmmoCrate(2021,1958,amGirder)	--underwater girders
	SpawnAmmoCrate(1970,1958,amJetpack)		-- (probably ) underwater

	cBaseball = SpawnAmmoCrate(3131,1965,amBaseballBat)	--castle
	SpawnAmmoCrate(3967,1955,amBlowTorch)	-- castle blowtorch
	cFirePunch1 = SpawnAmmoCrate(3632,1802,amFirePunch)	--castle
	cFirePunch2 = SpawnAmmoCrate(3496,1802,amFirePunch)	--castle
	cGirder2 = SpawnAmmoCrate(3468,1669,amGirder)	--castle

	--SpawnAmmoCrate(3028,234,amParachute) -- before portal chamber
	SpawnAmmoCrate(2370,440,amPortalGun)	--prelude portal chamber
	SpawnAmmoCrate(2775,244,amFirePunch)	--portal saga
	SpawnAmmoCrate(2715,244,amBlowTorch)	--portal saga
	SpawnAmmoCrate(2650,244,amParachute) -- before portal chamber
	SpawnUtilityCrate(3100,570,amExtraTime)	--portal chamber
	cPortalGun2 = SpawnUtilityCrate(3142,570,amPortalGun)	--portal chamber
	cLaserSite = SpawnUtilityCrate(3185,570,amLaserSight)	--portal chamber

	SpawnAmmoCrate(2174,1003,amShotgun) -- ice saga


	SpawnAmmoCrate(3908,79,amSniperRifle)	--sniper post



	--SpawnAmmoCrate(2825,979,amSkip)
	--SpawnUtilityCrate(3076,979,amSkip)



	-- mines at the end of girders
	AddGear(240, 1364, gtMine, 0, 0, 0, 0)
	AddGear(200, 1440, gtMine, 0, 0, 0, 0)
	AddGear(240, 1521, gtMine, 0, 0, 0, 0)
	AddGear(200, 1597, gtMine, 0, 0, 0, 0)

	-- mines at the start of girders
	AddGear(118, 1670, gtMine, 0, 0, 0, 0)
	AddGear(325, 1747, gtMine, 0, 0, 0, 0)
	AddGear(118, 1828, gtMine, 0, 0, 0, 0)

	AddGear(180, 1838, gtMine, 0, 0, 0, 0)
	AddGear(236, 1838, gtMine, 0, 0, 0, 0)
	AddGear(309, 1903, gtMine, 0, 0, 0, 0)


	AddGear(3310, 1578, gtExplosives, 0, 0, 0, 0)
	AddGear(3385, 1578, gtExplosives, 0, 0, 0, 0)
	AddGear(3477, 1578, gtExplosives, 0, 0, 0, 0)
	AddGear(3571, 1578, gtExplosives, 0, 0, 0, 0)
	AddGear(3649, 1578, gtExplosives, 0, 0, 0, 0)

	AddGear(3623, 1670, gtExplosives, 0, 0, 0, 0)
	AddGear(3674, 1670, gtExplosives, 0, 0, 0, 0)
	AddGear(3524, 1670, gtExplosives, 0, 0, 0, 0)
	AddGear(3400, 1670, gtExplosives, 0, 0, 0, 0)
	AddGear(3289, 1670, gtExplosives, 0, 0, 0, 0)

	AddGear(3341, 1760, gtExplosives, 0, 0, 0, 0)
	AddGear(3457, 1801, gtExplosives, 0, 0, 0, 0)
	AddGear(3538, 1800, gtExplosives, 0, 0, 0, 0)

	-- far end
	AddGear(3806, 1711, gtExplosives, 0, 0, 0, 0)

	--baseball time
	AddGear(2848, 1164, gtExplosives, 0, 0, 0, 0)


	-- Show some nice mission goals.
	-- Parameters are: caption, sub caption, description,
	-- extra text, icon and time to show.
	-- A negative icon parameter (-n) represents the n-th weapon icon
	-- A positive icon paramter (n) represents the (n+1)-th mission icon
	-- A timeframe of 0 is replaced with the default time to show.
	ShowMission(loc(caption), loc(subcaption), loc(goal), -amFirePunch, 0);
	--SetTag(AddGear(0, 0, gtATSmoothWindCh, 0, 0, 0, 1), -70)

	FollowGear(player)

end


function onGameTick()


	if (TotalRounds == 3) and (GameOver == false) then
		SetHealth(player, 0)
		GameOver = true
	end

	if CurrentHedgehog ~= nil then
		--AddCaption(GetX(player) .. "; ".. GetY(player))
	end

	--if TurnTimeLeft == 99500 then
	--	SetTag(AddGear(0, 0, gtATSmoothWindCh, 0, 0, 0, 1), -72)
	--end

	if TurnTimeLeft == 1 then
		--ShowMission(loc(caption), loc(subcaption), loc(timeout), -amSkip, 0);
		SetHealth(player, 0)
		GameOver = true
	end



	if (CurrentHedgehog ~= nil) then
		if cPortalGun2 == nil then
		--if (GearIsInZone(CurrentHedgehog, testChamber)) == true then
			--SetGearPosition(CurrentHedgehog,1402,321)
			if testChamberStarted == false then
				testChamberStarted = true
				--AddGear(3062, 300, gtCake, 0, 0, 0, 0)
				--AddGear(3203, 300, gtCake, 0, 0, 0, 0)

				--cake1 = AddGear(2948, 1, gtCake, 0, 0, 0, 0)
				--cake2 = AddGear(3028, 1, gtCake, 0, 0, 0, 0)
				--HogTurnLeft(cake2, true)
				--SetTimer(cake1, 5000)

				--AddGear(3062, 300, gtCake, 0, 0, 0, 0)
				--AddGear(3203, 300, gtCake, 0, 0, 0, 0)
				--AddGear(2948, 1, gtCake, 0, 0, 0, 0)
				--AddGear(3028, 1, gtCake, 0, 0, 0, 0)




			end
			--ShowMission("Hi there!", (GetHogName(CurrentHedgehog)), "Welcome home!", -amSeduction, 0)
		end
	end


end


function onAmmoStoreInit()

	SetAmmo(amBazooka, 0, 0, 0, 1)

	SetAmmo(amFirePunch, 2, 0, 0, 1)
	SetAmmo(amBaseballBat, 0, 0, 0, 1)

	SetAmmo(amMine, 0, 0, 0, 1)

	SetAmmo(amPickHammer, 1, 0, 0, 1)
	SetAmmo(amBlowTorch, 0, 0, 0, 1)
	SetAmmo(amGirder, 0, 0, 0, 2)
	SetAmmo(amPortalGun, 0, 0, 0, 1)
	SetAmmo(amShotgun, 0, 0, 0, 1)
	SetAmmo(amSniperRifle, 0, 0, 0, 1)

	SetAmmo(amDynamite, 0, 0, 0, 1)
	SetAmmo(amExtraTime, 0, 0, 0, 2)

	SetAmmo(amLaserSight,0,0,0,1)
	SetAmmo(amParachute, 0, 0, 0, 1)
	SetAmmo(amJetpack, 0, 0, 0, 1)
	--SetAmmo(amSkip, 9, 0, 0, 0)
end


function onGearAdd(gear)

	if GetGearType(gear) == gtJetpack then
		SetHealth(gear,1000)
	end

	if GetGearType(gear) == gtFlake then
		DeleteGear(gear)
	end

end

function onGearDelete(gear)


	--if (gear == cBlowTorch1) or (gear == cJetpack1) then
	if GetGearType(gear) == gtCase then
		TurnTimeLeft = TurnTimeLeft + 10000
	end

	if gear == cBaseball then
		TurnTimeLeft = TurnTimeLeft + 20000
	end

	if (gear == cFirePunch1) or (gear == cFirePunch2) or (gear == cGirder2) then
		TurnTimeLeft = TurnTimeLeft + 20000
	end

	if GetGearType(gear) == gtHedgehog then
	--if (gear == ehhs[0]) or (gear == ehhs[1]) or (gear == ehhs[2])  then
		TurnTimeLeft = TurnTimeLeft + 10000
	end

	if gear == cPortalGun2 then
		cPortalGun2 = nil
	end


	if (gear == ehhs[0]) and (GameOver == false) then
		--ShowMission(loc(caption), loc(subcaption), loc(success), 0, 0);
	elseif gear == player then
		ShowMission(loc(caption), loc(subcaption), loc(timeout), -amSkip, 0)
		GameOver = true
	end

end
